/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.item;

import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class CompassItemPropertyFunction
implements ClampedItemPropertyFunction {
    public static final int DEFAULT_ROTATION = 0;
    private final CompassWobble wobble = new CompassWobble();
    private final CompassWobble wobbleRandom = new CompassWobble();
    public final CompassTarget compassTarget;

    public CompassItemPropertyFunction(CompassTarget p_234933_) {
        this.compassTarget = p_234933_;
    }

    @Override
    public float unclampedCall(ItemStack p_234960_, @Nullable ClientLevel p_234961_, @Nullable LivingEntity p_234962_, int p_234963_) {
        Entity $$4;
        Entity entity = $$4 = p_234962_ != null ? p_234962_ : p_234960_.getEntityRepresentation();
        if ($$4 == null) {
            return 0.0f;
        }
        if ((p_234961_ = this.tryFetchLevelIfMissing($$4, p_234961_)) == null) {
            return 0.0f;
        }
        return this.getCompassRotation(p_234960_, p_234961_, p_234963_, $$4);
    }

    private float getCompassRotation(ItemStack p_234955_, ClientLevel p_234956_, int p_234957_, Entity p_234958_) {
        GlobalPos $$4 = this.compassTarget.getPos(p_234956_, p_234955_, p_234958_);
        long $$5 = p_234956_.getGameTime();
        if (!this.isValidCompassTargetPos(p_234958_, $$4)) {
            return this.getRandomlySpinningRotation(p_234957_, $$5);
        }
        return this.getRotationTowardsCompassTarget(p_234958_, $$5, $$4.pos());
    }

    private float getRandomlySpinningRotation(int p_234937_, long p_234938_) {
        if (this.wobbleRandom.shouldUpdate(p_234938_)) {
            this.wobbleRandom.update(p_234938_, Math.random());
        }
        double $$2 = this.wobbleRandom.rotation + (double)((float)this.hash(p_234937_) / 2.1474836E9f);
        return Mth.positiveModulo((float)$$2, 1.0f);
    }

    private float getRotationTowardsCompassTarget(Entity p_234942_, long p_234943_, BlockPos p_234944_) {
        double $$7;
        Player $$5;
        double $$3 = this.getAngleFromEntityToPos(p_234942_, p_234944_);
        double $$4 = this.getWrappedVisualRotationY(p_234942_);
        if (p_234942_ instanceof Player && ($$5 = (Player)p_234942_).isLocalPlayer() && $$5.level().tickRateManager().runsNormally()) {
            if (this.wobble.shouldUpdate(p_234943_)) {
                this.wobble.update(p_234943_, 0.5 - ($$4 - 0.25));
            }
            double $$6 = $$3 + this.wobble.rotation;
        } else {
            $$7 = 0.5 - ($$4 - 0.25 - $$3);
        }
        return Mth.positiveModulo((float)$$7, 1.0f);
    }

    @Nullable
    private ClientLevel tryFetchLevelIfMissing(Entity p_234946_, @Nullable ClientLevel p_234947_) {
        if (p_234947_ == null && p_234946_.level() instanceof ClientLevel) {
            return (ClientLevel)p_234946_.level();
        }
        return p_234947_;
    }

    private boolean isValidCompassTargetPos(Entity p_234952_, @Nullable GlobalPos p_234953_) {
        return p_234953_ != null && p_234953_.dimension() == p_234952_.level().dimension() && !(p_234953_.pos().distToCenterSqr(p_234952_.position()) < (double)1.0E-5f);
    }

    private double getAngleFromEntityToPos(Entity p_234949_, BlockPos p_234950_) {
        Vec3 $$2 = Vec3.atCenterOf(p_234950_);
        return Math.atan2($$2.z() - p_234949_.getZ(), $$2.x() - p_234949_.getX()) / 6.2831854820251465;
    }

    private double getWrappedVisualRotationY(Entity p_234940_) {
        return Mth.positiveModulo((double)(p_234940_.getVisualRotationYInDegrees() / 360.0f), 1.0);
    }

    private int hash(int p_234935_) {
        return p_234935_ * 1327217883;
    }

    static class CompassWobble {
        double rotation;
        private double deltaRotation;
        private long lastUpdateTick;

        CompassWobble() {
        }

        boolean shouldUpdate(long p_234973_) {
            return this.lastUpdateTick != p_234973_;
        }

        void update(long p_234975_, double p_234976_) {
            this.lastUpdateTick = p_234975_;
            double $$2 = p_234976_ - this.rotation;
            $$2 = Mth.positiveModulo($$2 + 0.5, 1.0) - 0.5;
            this.deltaRotation += $$2 * 0.1;
            this.deltaRotation *= 0.8;
            this.rotation = Mth.positiveModulo(this.rotation + this.deltaRotation, 1.0);
        }
    }

    public static interface CompassTarget {
        @Nullable
        public GlobalPos getPos(ClientLevel var1, ItemStack var2, Entity var3);
    }
}

